<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products_ads', function (Blueprint $table) {

            $table->id();
            $table->string('name');

            $table->string('price');

            $table->string('main_image');
            $table->string('license_number');
            $table->longText('desc');
            $table->string('area_in_metres', 30);
            $table->integer('room_numbers');
            $table->integer('bathrooms_numbers');
            $table->integer('parking_numbers')->nullable();
            $table->text('location');
            $table->string('video_url')->nullable();
            $table->enum('display_status', ['1', '0'])->default('1');



            // Relation
            $table->unsignedBigInteger('property_type')->nullable();
            $table->foreign('property_type')->references('id')->on('product_property_types')->onDelete("set null")->onUpdate('cascade');


            // Relation
            $table->unsignedBigInteger('developer')->nullable();
            $table->foreign('developer')->references('id')->on('developers_real_estates')->onDelete("set null")->onUpdate('cascade');

            // Relation
            $table->unsignedBigInteger('status')->nullable();
            $table->foreign('status')->references('id')->on('product_statuses')->onDelete("set null")->onUpdate('cascade');
            // Relation
            $table->unsignedBigInteger('deal_type')->nullable();
            $table->foreign('deal_type')->references('id')->on('product_dealing_types')->onDelete("set null")->onUpdate('cascade');
            // Relation
            $table->unsignedBigInteger('city')->nullable();
            $table->foreign('city')->references('id')->on('cities')->onDelete("set null")->onUpdate('cascade');
            // Relation
            $table->unsignedBigInteger('neighborhood')->nullable();
            $table->foreign('neighborhood')->references('id')->on('neighborhoods')->onDelete("set null")->onUpdate('cascade');
            // Relation
            $table->unsignedBigInteger('build_type')->nullable();
            $table->foreign('build_type')->references('id')->on('product_building_types')->onDelete("set null")->onUpdate('cascade');

            // Relation
            $table->unsignedBigInteger('created_by')->nullable();
            $table->foreign('created_by')->references('id')->on('admins')->onDelete("set null")->onUpdate('cascade');


            $table->string('slug');
            $table->string('logo');
            
            $table->integer('view')->default(0);
            $table->integer('click_profile')->default(0);
            $table->integer('click_whats')->default(0);
            $table->integer('click_phone')->default(0);

            $table->string('navbar_color')->default('#000000');
            $table->string('navbar_bg')->default('#ffffff');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products_ads');
    }
};
